# -*- coding: utf-8 -*-

import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib as mpl
from pathlib import Path
from matplotlib import rc
rc('font',**{'family':'sans-serif','sans-serif':['Helvetica']})
# FlatUI
flat_ui = ['#2ecc71', '#3498db', '#9b59b6', '#f1c40f', '#e67e22', '#e74c3c', '#1abc9c', '#34495e']
flat_ui = ['#1abc9c', '#2ecc71', '#3498db', '#9b59b6', '#34495e', '#f1c40f', '#e67e22', '#e74c3c']
flat_ui = ['#5E5E5E', '#FAA43A', '#60BD68', '#F17CB0', '#B2912F', '#B276B2', '#DECF3F', '#F15854']
flat_ui = ['#1BBC9B', '#3498DB', '#9B59B6', '#F1C40F', '#E67E22', '#E74C3C', '#2C3E50', '#7F8C8D']
flat_ui = ['#0072B2', '#009E73', '#D55E00', '#CC79A7', '#F0E442', '#56B4E9', '#E69F00', '#000000']
flat_ui = ['#4e79a7', '#f28e2b', '#e15759', '#76b7b2', '#59a14f', '#edc948', '#b07aa1', '#ff9da7', '#9c755f', '#bab0ac']
flat_ui = plt.cm.viridis(np.linspace(0, 1, 6))
flat_ui = ["#e41a1c", "#377eb8", "#4daf4a", "#984ea3", "#ff7f00", "#ffff33", "#a65628", "#f781bf", "#999999", "#a6cee3"]
flat_ui = ["#1b9e77", "#d95f02", "#7570b3", "#e7298a", "#66a61e", "#e6ab02", "#a6761d", "#666666"]  # イケてる（Dark2?）
# mpl.rcParams['axes.prop_cycle'] = mpl.cycler(color=flat_ui)

source_data_path = "3_alignment_consensus_core_results_analysis_hist_df_10000_(1-40)_20250331.csv"
df = pd.read_csv(source_data_path, sep="\t", index_col=0)

print(df)

df_pivot = df.pivot_table(values="is correctly assigned", index="# of reads", columns="prior type")
print(df_pivot)
df_pivot = df_pivot.reindex(columns=["without prior", "with prior", "with wrong prior"])


fig = plt.figure(figsize=(4, 5))
ax1 = fig.add_subplot(2, 1, 1)
ax2 = fig.add_subplot(2, 1, 2)
df_pivot.plot(ax=ax1)
df_pivot = 1 - df_pivot.iloc[1:, :]
df_pivot.plot(ax=ax2)
ax2.set_yscale('log')

# ラベル
ax1.set_ylabel("probability of correct\nconsensus base calling")
ax1.set_xticklabels([])
ax1.set(xlabel=None)
handles, labels = ax1.get_legend_handles_labels()
ax1.legend(handles=handles[:], labels=labels[:])
ax2.set_ylabel("probability of incorrect\nconsensus base calling (log)")
ax2.get_legend().remove()
plt.subplots_adjust(left=0.2, right=0.95, top=0.98, bottom=0.1, hspace=0.05)
plt.savefig(f"{Path(__file__).stem}.svg")
plt.show()


